/*

 Copyright 2006-2023 Kiubi SAS.

 Composants specifiques au theme Kiubi pour Bootstrap v3.3.7 (http://getbootstrap.com)

 Theme sous licence Beerware (https://fr.wikipedia.org/wiki/Beerware)

 ----------------------------------------------------------------------------
 "THE BEER-WARE LICENSE" (Revision 42):
 <contact@kiubi.com> wrote this file. As long as you retain this notice you
 can do whatever you want with this stuff. If we meet some day, and you think
 this stuff is worth it, you can buy us a beer in return. Kiubi
 ----------------------------------------------------------------------------

*/

$(function () {
	$('[data-toggle="tooltip"]').tooltip();
});

$(function () {
	$('#returnTop').click( function() {
		$('html,body').animate({scrollTop: 0}, 'fast');
	});
});


// Lightbox
$(document).on('click', '[data-toggle="lightbox"]', function(event) {
    event.preventDefault();
    $(this).ekkoLightbox();
});

// Moteur de recherche des produits avec filtres
$(function() {
	var $liste = $('#produits_liste');
	if ($liste.length == 0) return;

	var listing = new KiubiComponent.ProductListing({
		uiBtn:$('#produits_more'),
		uiList:$liste,
		uiListCount:$('#produits_count'),
		uiTpl:$('#produits_tpl'),
		uiPagination:$('a[data-pagination]'),
		uiOrder:$('a[data-tri]'),
	});

	listing.init();
	listing.start();
});


// Galerie completee par API
$(function(){
	// attribut data-remote-gallery prsent et non vide
	$('[data-remote-gallery][data-remote-gallery!=""][data-remote-gallery-enable="true"]').each(function(){
		new KiubiComponent.remoteGallery({
			folder_id:$(this).data('remote-gallery'),
			uiTpl:$('script[type="text/x-template"]', this),
			containerEl: $('.row', this)
		});
	});
});


// Gestion des plages horaires des retraits en boutique et des livraisons
// Utilisation de l'API Front-office de Kiubi
if (document.location.pathname === '/ecommerce/transporteurs.html') {
	$(function(){
		var mgr = new KiubiComponent.schedulingPicker();
		mgr.init();
	});
}

// Owl Carousel
$(function(){

	var sizes = [0, 768, 992, 1200];

	$('.owl-carousel').each(function(){

		var $el = $(this);

		var margin  = $el.data('owl-margin') || 0;
		var nav = ($el.data('owl-nav') !== false);
		var dots = ($el.data('owl-dots') === true);
		var animateOut = $el.data('owl-animateout') || false; // classique usage : 'fadeOut'
		var resp_data = ($el.data('owl-responsive') || '1-2-4').split('-');
		var responsive = {};
		for(var i=0; i< resp_data.length; i++) {
			if (i >= sizes.length) continue;
			responsive[ sizes[i] ] = {items:parseInt(resp_data[i])};
		}
		$el.owlCarousel({
			loop:true,
			margin:margin,
			nav:nav,
            dots:dots,
			autoHeight:false,
			autoplay:true,
			autoplayTimeout:5000,
			navText:["<span class=\"material-icons\" aria-hidden=\"true\">keyboard_arrow_left</span>","<span class=\"material-icons\" aria-hidden=\"true\">keyboard_arrow_right</span>"],
			animateOut:animateOut,
			responsive:responsive
		});

	});

});

// Datepicker
$(function(){

	$("input.datepicker").datetimepicker({
		locale: 'fr',
		format: "DD/MM/YYYY"
	});

	$("input.datetimepicker").datetimepicker({
		locale: 'fr',
		format: "DD/MM/YYYY HH:mm"
	});

});

// EasyZoom + Mise a jour du prix dans la fiche produit
$(function(){
	
	var $easyzoom = $('.easyzoom').easyZoom();

	var thumbnails = $easyzoom.filter('.easyzoom-with-thumbnails').data('easyZoom');

	$('.listing-images').on('click', 'a', function(e) {
		var $this = $(this);
		e.preventDefault();
		thumbnails.swap($this.data('standard'), $this.attr('href'));
	});
	
	$('select[name="vid"]').on('change', function(e) {
        var option = $("option:selected", this);
		
		// Mise a jour du prix dans la fiche produit a la selection de variante
		var price = option.data('price');
		if (price) {
			price = price.split('|'); // price contient le prix de base et le prix promo separes par un `|`
			$('#'+ $(this).data('price')).html(
				price[0] + (price.length == 2 && price[1] !== '' ? ' <del class="text-muted">' + price[1] + '</del>': '')
			);
		}

		// Selection des images des variantes
		if (!option.data('standard') || !option.data('zoom')) return;
		thumbnails.swap(option.data('standard'), option.data('zoom'));
	})
	.each(function(){
		// Selection automatique de la variante en fonction du parametre `variant` dans l'URL
		var variant_id = $(this).data('variant');
		if (!variant_id || !Number.isInteger(variant_id)) return;

		var option = $('option', this).filter('[value="'+variant_id+'"]:not([disabled])'); // ignore les variantes en rupture
		if (option.length != 1) return;

		$(this).val(variant_id);
		$(this).trigger('change'); // declenche la mise a jour du prix
	});

});

// Animate On Scroll Library
$(function(){
	AOS.init({
		duration: 500,
		offset: 150,
		delay: 0,
		once: true
	});
});

// Custom dynamic file input 
$(function () {
	bsCustomFileInput.init();
});

// Ajout dynamique au panier
// Utilisation de l'API Front-office de Kiubi
$(function () {
	new KiubiComponent.cartAdd({
		addBtn: $('button[data-cart-add]'),
		cartSummary: $('a[data-cart]'),
		cartNotification: $('div[data-cart-alert]')
	});
});

// Countdown
$(function() {
    var t = document.querySelectorAll("[data-countdown]");

    function o(t, e) {
        var a = t - (new Date).getTime(),
            o = Math.floor(a / 864e5);
        o = o < 10 ? "0" + o : o;
        var n = Math.floor(a % 864e5 / 36e5);
        n = n < 10 ? "0" + n : n;
        var l = Math.floor(a % 36e5 / 6e4);
        l = l < 10 ? "0" + l : l;
        var i = Math.floor(a % 6e4 / 1e3);
        i = i < 10 ? "0" + i : i, e.querySelector("[data-days]").innerHTML = o, e.querySelector("[data-hours]").innerHTML = n, e.querySelector("[data-minutes]").innerHTML = l, e.querySelector("[data-seconds]").innerHTML = i
    }
    t.length && [].forEach.call(t, function(t) {
        ! function(t) {
            var d = t.dataset.date.split(/:+|\s+|-+|\/+/);
            d[1] = parseInt(d[1])-1;
            var a = new Date(d[2], d[1], d[0], d[3], d[4], d[5]).getTime();
            o(a, t), setInterval(function() {
                o(a, t)
            }, 1e3)
        }(t)
    })
});

// Barre d'annonce
$(function(){

   $('.composant-annonce').each(function(){

		 var annonce = $(this);
     var expires = Math.round(annonce.data('annonce-expires'));
		 var customer = annonce.data('customer');
		 var show_for_customers = annonce.data('show-for-customers');
		 var cookieName = 'kc-'+annonce.data('cookie');
     var annonceCookies = Cookies.get(cookieName);

		 if (!expires) expires = 0;

		 //Masque la barre d'annnonce si l'internaute n'est pas connecte au site
		 if(customer == '' && show_for_customers == 'loggedout') {

			 annonce.alert('close');
			 return;

		 }

		 //Masque la barre d'annnonce si l'internaute est connecte au site
		 if(customer > 0 && show_for_customers == 'loggedin') {

			 annonce.alert('close');
			 return;

		 }

     if (annonceCookies != '1') {

			 annonce.removeClass('d-none');

			 $('button[data-dismiss]', this).on('click', function() {
	 				Cookies.set(cookieName, '1', {
	 						expires: expires,
	 						path: '/'
	 				});
	 			});

	 		} else {

	 			annonce.alert('close');

	 		}

   });

});

// tarteaucitron
tarteaucitron.cdn = _.find(document.getElementsByTagName('script'), function(script){return script.src.indexOf('/js.js') >= 0}).src.split('/').slice(0, -1).join('/') + '/tarteaucitron/';

tarteaucitron.services.matomoconsent = {
    "key": "matomoconsent",
    "type": "analytic",
    "name": "Matomo (privacy by design)",
    "uri": "https://matomo.org/faq/general/faq_146/",
    "needConsent": true,
    "cookies": ['_pk_ref', '_pk_cvar', '_pk_id', '_pk_ses', '_pk_hsr', 'mtm_consent', 'matomo_ignore', 'matomo_sessid'],
    "js": function () {
        "use strict";
        if (tarteaucitron.user.matomoId === undefined || tarteaucitron.user.matomoHost === undefined) {
            return;
        }

        window._paq = window._paq || [];
        window._paq.push(["setSiteId", tarteaucitron.user.matomoId]);
        window._paq.push(["setTrackerUrl", tarteaucitron.user.matomoHost + "matomo.php"]);
        window._paq.push(["setDoNotTrack", 1]);
        window._paq.push(["trackPageView"]);
        window._paq.push(["setIgnoreClasses", ["no-tracking", "colorbox"]]);
        window._paq.push(["enableLinkTracking"]);
        window._paq.push([function () {
            var self = this;
            function getOriginalVisitorCookieTimeout() {
                var now = new Date(),
                    nowTs = Math.round(now.getTime() / 1000),
                    visitorInfo = self.getVisitorInfo();
                var createTs = parseInt(visitorInfo[2]);
                var cookieTimeout = 33696000; // 13 mois en secondes
                var originalTimeout = createTs + cookieTimeout - nowTs;
                return originalTimeout;
            }
            this.setVisitorCookieTimeout(getOriginalVisitorCookieTimeout());
        }]);

       // Handle specific cdn matomo cloud url
       var isCloud = tarteaucitron.user.matomoHost.match(/^https:\/\/([^\.]+\.matomo\.cloud\/)/)
       var trackerDomain = isCloud ? 'https://cdn.matomo.cloud/' + isCloud[1] : tarteaucitron.user.matomoHost;
       tarteaucitron.addScript(trackerDomain + 'matomo.js', '', '', true, 'defer', true);

        // waiting for Matomo to be ready to check first party cookies
        var interval = setInterval(function () {
            if (typeof Matomo === 'undefined') return;

            clearInterval(interval);

            // make Matomo cookie accessible by getting tracker
            Matomo.getTracker();

            // looping through cookies
            var theCookies = document.cookie.split(';');
            for (var i = 1; i <= theCookies.length; i++) {
                var cookie = theCookies[i - 1].split('=');
                var cookieName = cookie[0].trim();

                // if cookie starts like a matomo one, register it
                if (cookieName.indexOf('_pk_') === 0) {
                    tarteaucitron.services.matomoconsent.cookies.push(cookieName);
                }
            }
        }, 100);
    }
};

tarteaucitron.init({
    "privacyUrl": "", /* Privacy policy url */

    "hashtag": "#tarteaucitron", /* Open the panel with this hashtag */
    "cookieName": "tarteaucitron", /* Cookie name */

    "orientation": "bottom", /* Banner position (top - bottom - middle - popup) */

    "groupServices": false, /* Group services by category */

    "showAlertSmall": false, /* Show the small banner on bottom right */
    "cookieslist": false, /* Show the cookie list */
    
    "showIcon": false, /* Show cookie icon to manage cookies */
    // "iconSrc": "", /* Optionnal: URL or base64 encoded image */
    "iconPosition": "BottomRight", /* Position of the icon between BottomRight, BottomLeft, TopRight and TopLeft */

    "adblocker": false, /* Show a Warning if an adblocker is detected */

    "DenyAllCta" : true, /* Show the deny all button */
    "AcceptAllCta" : true, /* Show the accept all button when highPrivacy on */
    "highPrivacy": true, /* HIGHLY RECOMMANDED Disable auto consent */

    "handleBrowserDNTRequest": false, /* If Do Not Track == 1, disallow all */

    "removeCredit": true, /* Remove credit link */
    "moreInfoLink": true, /* Show more info link */
    "useExternalCss": true, /* If false, the tarteaucitron.css file will be loaded */

    //"cookieDomain": ".my-multisite-domaine.fr", /* Shared cookie for subdomain website */

    "readmoreLink": "", /* Change the default readmore link pointing to tarteaucitron.io */
    
    "mandatory": true /* Show a message about mandatory cookies */
});

// Boostrap TouchSpin
$("input[data-touchspin='vertical-icons']").TouchSpin({
			min: 1,
      max: 100,
      verticalbuttons: true,
      verticalupclass: 'glyphicon glyphicon-plus',
      verticaldownclass: 'glyphicon glyphicon-minus',
			buttondown_class: 'btn btn-link border',
			buttonup_class: 'btn btn-link border',
			prefix_extraclass: 'd-none',
			postfix_extraclass: 'd-none',
			postfix: ' ',
			prefix: ' '
});